set linesize 200
/************************************************************************************#
#*                                                                                   #
#* Purpose: STATA program to create permanent .DTA data set                          #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta             #
#*          with the Harmonized TUS CPS 1992 through 2019 replicate weights 92-93    #
#*                                                                                   #
#*          The program does NOT use STATA dictionaries                              #
#*                                                                                   #
#*************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg\3. Harmonized data"

//*****************************************************************************************
// Create dictionary

file open dictionary  using ".\dictionary.dct", write replace
set more off

file write dictionary   /// 
"infile dictionary {" _n ///
"_column(1)"   _tab "int   " _tab "SurYear " _tab "%4f   " _tab `""Survey year""' _n ///
"_column(5)"   _tab "int   " _tab "SurMonth" _tab "%2f   " _tab `""Survey month""' _n ///
"_column(7)"   _tab "str22 " _tab "RecordID" _tab "%22s  " _tab `""Record ID (Unique within survey month)""' _n ///
"_column(29)"  _tab "double" _tab "SmplWgt " _tab "%11.4f" _tab `""Self Response Sample Weight""' _n ///
"_column(40)"  _tab "double" _tab "RepWt001" _tab "%11.4f" _tab `""Replicate Weight #1""' _n ///
"_column(51)"  _tab "double" _tab "RepWt002" _tab "%11.4f" _tab `""Replicate Weight #2""' _n ///
"_column(62)"  _tab "double" _tab "RepWt003" _tab "%11.4f" _tab `""Replicate Weight #3""' _n ///
"_column(73)"  _tab "double" _tab "RepWt004" _tab "%11.4f" _tab `""Replicate Weight #4""' _n ///
"_column(84)"  _tab "double" _tab "RepWt005" _tab "%11.4f" _tab `""Replicate Weight #5""' _n ///
"_column(95)"  _tab "double" _tab "RepWt006" _tab "%11.4f" _tab `""Replicate Weight #6""' _n ///
"_column(106)" _tab "double" _tab "RepWt007" _tab "%11.4f" _tab `""Replicate Weight #7""' _n ///
"_column(117)" _tab "double" _tab "RepWt008" _tab "%11.4f" _tab `""Replicate Weight #8""' _n ///
"_column(128)" _tab "double" _tab "RepWt009" _tab "%11.4f" _tab `""Replicate Weight #9""' _n ///
"_column(139)" _tab "double" _tab "RepWt010" _tab "%11.4f" _tab `""Replicate Weight #10""' _n ///
"_column(150)" _tab "double" _tab "RepWt011" _tab "%11.4f" _tab `""Replicate Weight #11""' _n ///
"_column(161)" _tab "double" _tab "RepWt012" _tab "%11.4f" _tab `""Replicate Weight #12""' _n ///
"_column(172)" _tab "double" _tab "RepWt013" _tab "%11.4f" _tab `""Replicate Weight #13""' _n ///
"_column(183)" _tab "double" _tab "RepWt014" _tab "%11.4f" _tab `""Replicate Weight #14""' _n ///
"_column(194)" _tab "double" _tab "RepWt015" _tab "%11.4f" _tab `""Replicate Weight #15""' _n ///
"_column(205)" _tab "double" _tab "RepWt016" _tab "%11.4f" _tab `""Replicate Weight #16""' _n ///
"_column(216)" _tab "double" _tab "RepWt017" _tab "%11.4f" _tab `""Replicate Weight #17""' _n ///
"_column(227)" _tab "double" _tab "RepWt018" _tab "%11.4f" _tab `""Replicate Weight #18""' _n ///
"_column(238)" _tab "double" _tab "RepWt019" _tab "%11.4f" _tab `""Replicate Weight #19""' _n ///
"_column(249)" _tab "double" _tab "RepWt020" _tab "%11.4f" _tab `""Replicate Weight #20""' _n ///
"_column(260)" _tab "double" _tab "RepWt021" _tab "%11.4f" _tab `""Replicate Weight #21""' _n ///
"_column(271)" _tab "double" _tab "RepWt022" _tab "%11.4f" _tab `""Replicate Weight #22""' _n ///
"_column(282)" _tab "double" _tab "RepWt023" _tab "%11.4f" _tab `""Replicate Weight #23""' _n ///
"_column(293)" _tab "double" _tab "RepWt024" _tab "%11.4f" _tab `""Replicate Weight #24""' _n ///
"_column(304)" _tab "double" _tab "RepWt025" _tab "%11.4f" _tab `""Replicate Weight #25""' _n ///
"_column(315)" _tab "double" _tab "RepWt026" _tab "%11.4f" _tab `""Replicate Weight #26""' _n ///
"_column(326)" _tab "double" _tab "RepWt027" _tab "%11.4f" _tab `""Replicate Weight #27""' _n ///
"_column(337)" _tab "double" _tab "RepWt028" _tab "%11.4f" _tab `""Replicate Weight #28""' _n ///
"_column(348)" _tab "double" _tab "RepWt029" _tab "%11.4f" _tab `""Replicate Weight #29""' _n ///
"_column(359)" _tab "double" _tab "RepWt030" _tab "%11.4f" _tab `""Replicate Weight #30""' _n ///
"_column(370)" _tab "double" _tab "RepWt031" _tab "%11.4f" _tab `""Replicate Weight #31""' _n ///
"_column(381)" _tab "double" _tab "RepWt032" _tab "%11.4f" _tab `""Replicate Weight #32""' _n ///
"_column(392)" _tab "double" _tab "RepWt033" _tab "%11.4f" _tab `""Replicate Weight #33""' _n ///
"_column(403)" _tab "double" _tab "RepWt034" _tab "%11.4f" _tab `""Replicate Weight #34""' _n ///
"_column(414)" _tab "double" _tab "RepWt035" _tab "%11.4f" _tab `""Replicate Weight #35""' _n ///
"_column(425)" _tab "double" _tab "RepWt036" _tab "%11.4f" _tab `""Replicate Weight #36""' _n ///
"_column(436)" _tab "double" _tab "RepWt037" _tab "%11.4f" _tab `""Replicate Weight #37""' _n ///
"_column(447)" _tab "double" _tab "RepWt038" _tab "%11.4f" _tab `""Replicate Weight #38""' _n ///
"_column(458)" _tab "double" _tab "RepWt039" _tab "%11.4f" _tab `""Replicate Weight #39""' _n ///
"_column(469)" _tab "double" _tab "RepWt040" _tab "%11.4f" _tab `""Replicate Weight #40""' _n ///
"_column(480)" _tab "double" _tab "RepWt041" _tab "%11.4f" _tab `""Replicate Weight #41""' _n ///
"_column(491)" _tab "double" _tab "RepWt042" _tab "%11.4f" _tab `""Replicate Weight #42""' _n ///
"_column(502)" _tab "double" _tab "RepWt043" _tab "%11.4f" _tab `""Replicate Weight #43""' _n ///
"_column(513)" _tab "double" _tab "RepWt044" _tab "%11.4f" _tab `""Replicate Weight #44""' _n ///
"_column(524)" _tab "double" _tab "RepWt045" _tab "%11.4f" _tab `""Replicate Weight #45""' _n ///
"_column(535)" _tab "double" _tab "RepWt046" _tab "%11.4f" _tab `""Replicate Weight #46""' _n ///
"_column(546)" _tab "double" _tab "RepWt047" _tab "%11.4f" _tab `""Replicate Weight #47""' _n ///
"_column(557)" _tab "double" _tab "RepWt048" _tab "%11.4f" _tab `""Replicate Weight #48""' _n ///
"}"

set more on
file close dictionary 

//*****************************************************************************************
// Read 1992 to 1993 replicate weights

quietly infile using dictionary.dct, using ("./harmonzd.tus_cps.1992.through.2019.replicate.wgts.92_93.dat") clear

describe
                                                   
save harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta, replace

erase "dictionary.dct"

